var myTone;
var tremolo;

function setup() {
    createCanvas(300, 300);
    useSound();
}

function soundSetup() { // setup for audio generation
    myTone = new p5.Oscillator();
    myTone.setType('sine');
    myTone.start();
    tremolo = new p5.Oscillator();
    tremolo.setType('sine');
    tremolo.disconnect();   // don't send this to speakers
    tremolo.start();
}

function draw() {
    background(200);
    fill(0);
    ellipse(mouseX, mouseY, 20, 20);
    tremolo.amp(0.75);
    // Amplitude Modulation - Note the change in the frequency range:
    tremolo.freq(constrain(100 + 100 * (mouseX / width), 100, 200));
    myTone.amp(tremolo);
    myTone.freq(constrain(200 + 1000 * (mouseY / height), 200, 1200));
    if (mouseX > 2*width) {
        myTone.stop();
        noLoop();
    }
}